//Listing 17.3. Projekt klasy wielokrotnego wykorzystania dla stosu przechowujcego obiekty klasy Point
#include <iostream>
using namespace std;

class Point;
ostream& operator << (ostream& out, const Point& p);

class Point {
       int x, y;

friend ostream& operator << (ostream& out, const Point& p);
public:
       Point() { }           // domylny konstruktor: pusty
       Point(const Point &p) // konstruktor kopiujcy: w celu zwrcenia
       { x = p.x; y = p.y; }
       void set(int a, int b) // ustaw wsprzdne okrelone przez klas Point
       { x = a; y = b; }
} ;

ostream& operator << (ostream& out, const Point& p)
{ out << "(" << p.x << "," << p.y << ")";
  return out; }

template <class Type>
class Stack {
  Type *items;   // stos elementw typu Type
  int top, size; // biecy wierzchoek stosu, cakowity rozmiar
  Stack(const Stack&);
  operator = (const Stack&);
public:
  Stack(int); // konstruktor konwertujcy
  void push(const Type&); // umie na stosie
  Type pop(); // zdejmij ze stosu
  bool isEmpty() const; // czy stos jest pusty?
  ~Stack(); // zwolnij pami na stercie
} ;

template <class Type>
Stack<Type>::Stack(int sz = 100) : size(sz),top(0)
{ items = new Type[sz]; // przydziel pami na stercie
  if (items==0)
  { cout << "Brak pamici\n"; exit(1); } }

template <class T>
void Stack<T>::push (const T& c)
 { if (top < size) // normalny przypadek: umie symbol
     items[top++] = c;
   else // obsu przepenienie stosu
     { T *p = new T[size*2]; // przydziel wicej pamici na stercie
       if (p == 0) // sprawd powodzenie
          { cout << "Brak pamici\n"; exit(1); }
       for (int i=0; i < size; i++) // skopiuj biecy stos
       p[i] = items[i];
       delete [] items; // zwolnij pami na stercie
       items = p; // podcz nowy obszar pamici
       size *= 2; // uaktualnij nowy rozmiar stosu
       cout << "Nowy rozmiar: " << size << endl;
       items[top++] = c; } } // umie symbol na stosie

template <class Type>
Type Stack<Type>::pop()
{ return items[--top]; } // bezwarunkowo zdejmij

template <class Tp>
bool Stack<Tp>::isEmpty() const // czy zostaa jeszcze warto do zdjcia?
{ return top == 0; }

template <class Type>
Stack<Type>::~Stack()
{ delete [] items; } // zwolnij pami na stercie

int main()
{
  Point data[5];
  data[0].set(1, 2); data[1].set(3, 4); data[2].set(5, 6);
  data[3].set(7, 8); data[4].set(9, 0);
  Stack<Point> s(4); // obiekt stosu
  int n = sizeof(data)/sizeof(Point); // liczba elementw
  cout << "Dane pocztkowe: ";
  for (int j = 0; j < n; j++)
      { cout << data[j] << " "; } // wywietl dane pocztkowe
  cout << endl;
  for (int i = 0; i < n; i++)
      { s.push(data[i]); } // umie dane na stosie
  cout << "Dane odwrcone: ";
  while (!s.isEmpty()) // zdejmuj ze stosu do czasu jego oprnienia
  cout << s.pop() << " ";
  cout << endl;
  return 0;
}
